// Code generated by astool. DO NOT EDIT.

package propertydependson

import (
	"fmt"
	vocab "github.com/go-fed/activity/streams/vocab"
	"net/url"
)

// ForgeFedDependsOnPropertyIterator is an iterator for a property. It is
// permitted to be a single nilable value type.
type ForgeFedDependsOnPropertyIterator struct {
	forgefedTicketMember vocab.ForgeFedTicket
	unknown              interface{}
	iri                  *url.URL
	alias                string
	myIdx                int
	parent               vocab.ForgeFedDependsOnProperty
}

// NewForgeFedDependsOnPropertyIterator creates a new ForgeFedDependsOn property.
func NewForgeFedDependsOnPropertyIterator() *ForgeFedDependsOnPropertyIterator {
	return &ForgeFedDependsOnPropertyIterator{alias: ""}
}

// deserializeForgeFedDependsOnPropertyIterator creates an iterator from an
// element that has been unmarshalled from a text or binary format.
func deserializeForgeFedDependsOnPropertyIterator(i interface{}, aliasMap map[string]string) (*ForgeFedDependsOnPropertyIterator, error) {
	alias := ""
	if a, ok := aliasMap["https://forgefed.peers.community/ns"]; ok {
		alias = a
	}
	if s, ok := i.(string); ok {
		u, err := url.Parse(s)
		// If error exists, don't error out -- skip this and treat as unknown string ([]byte) at worst
		// Also, if no scheme exists, don't treat it as a URL -- net/url is greedy
		if err == nil && len(u.Scheme) > 0 {
			this := &ForgeFedDependsOnPropertyIterator{
				alias: alias,
				iri:   u,
			}
			return this, nil
		}
	}
	if m, ok := i.(map[string]interface{}); ok {
		if v, err := mgr.DeserializeTicketForgeFed()(m, aliasMap); err == nil {
			this := &ForgeFedDependsOnPropertyIterator{
				alias:                alias,
				forgefedTicketMember: v,
			}
			return this, nil
		}
	}
	this := &ForgeFedDependsOnPropertyIterator{
		alias:   alias,
		unknown: i,
	}
	return this, nil
}

// Get returns the value of this property. When IsForgeFedTicket returns false,
// Get will return any arbitrary value.
func (this ForgeFedDependsOnPropertyIterator) Get() vocab.ForgeFedTicket {
	return this.forgefedTicketMember
}

// GetIRI returns the IRI of this property. When IsIRI returns false, GetIRI will
// return any arbitrary value.
func (this ForgeFedDependsOnPropertyIterator) GetIRI() *url.URL {
	return this.iri
}

// GetType returns the value in this property as a Type. Returns nil if the value
// is not an ActivityStreams type, such as an IRI or another value.
func (this ForgeFedDependsOnPropertyIterator) GetType() vocab.Type {
	if this.IsForgeFedTicket() {
		return this.Get()
	}

	return nil
}

// HasAny returns true if the value or IRI is set.
func (this ForgeFedDependsOnPropertyIterator) HasAny() bool {
	return this.IsForgeFedTicket() || this.iri != nil
}

// IsForgeFedTicket returns true if this property is set and not an IRI.
func (this ForgeFedDependsOnPropertyIterator) IsForgeFedTicket() bool {
	return this.forgefedTicketMember != nil
}

// IsIRI returns true if this property is an IRI.
func (this ForgeFedDependsOnPropertyIterator) IsIRI() bool {
	return this.iri != nil
}

// JSONLDContext returns the JSONLD URIs required in the context string for this
// property and the specific values that are set. The value in the map is the
// alias used to import the property's value or values.
func (this ForgeFedDependsOnPropertyIterator) JSONLDContext() map[string]string {
	m := map[string]string{"https://forgefed.peers.community/ns": this.alias}
	var child map[string]string
	if this.IsForgeFedTicket() {
		child = this.Get().JSONLDContext()
	}
	/*
	   Since the literal maps in this function are determined at
	   code-generation time, this loop should not overwrite an existing key with a
	   new value.
	*/
	for k, v := range child {
		m[k] = v
	}
	return m
}

// KindIndex computes an arbitrary value for indexing this kind of value. This is
// a leaky API detail only for folks looking to replace the go-fed
// implementation. Applications should not use this method.
func (this ForgeFedDependsOnPropertyIterator) KindIndex() int {
	if this.IsForgeFedTicket() {
		return 0
	}
	if this.IsIRI() {
		return -2
	}
	return -1
}

// LessThan compares two instances of this property with an arbitrary but stable
// comparison. Applications should not use this because it is only meant to
// help alternative implementations to go-fed to be able to normalize
// nonfunctional properties.
func (this ForgeFedDependsOnPropertyIterator) LessThan(o vocab.ForgeFedDependsOnPropertyIterator) bool {
	// LessThan comparison for if either or both are IRIs.
	if this.IsIRI() && o.IsIRI() {
		return this.iri.String() < o.GetIRI().String()
	} else if this.IsIRI() {
		// IRIs are always less than other values, none, or unknowns
		return true
	} else if o.IsIRI() {
		// This other, none, or unknown value is always greater than IRIs
		return false
	}
	// LessThan comparison for the single value or unknown value.
	if !this.IsForgeFedTicket() && !o.IsForgeFedTicket() {
		// Both are unknowns.
		return false
	} else if this.IsForgeFedTicket() && !o.IsForgeFedTicket() {
		// Values are always greater than unknown values.
		return false
	} else if !this.IsForgeFedTicket() && o.IsForgeFedTicket() {
		// Unknowns are always less than known values.
		return true
	} else {
		// Actual comparison.
		return this.Get().LessThan(o.Get())
	}
}

// Name returns the name of this property: "ForgeFedDependsOn".
func (this ForgeFedDependsOnPropertyIterator) Name() string {
	if len(this.alias) > 0 {
		return this.alias + ":" + "ForgeFedDependsOn"
	} else {
		return "ForgeFedDependsOn"
	}
}

// Next returns the next iterator, or nil if there is no next iterator.
func (this ForgeFedDependsOnPropertyIterator) Next() vocab.ForgeFedDependsOnPropertyIterator {
	if this.myIdx+1 >= this.parent.Len() {
		return nil
	} else {
		return this.parent.At(this.myIdx + 1)
	}
}

// Prev returns the previous iterator, or nil if there is no previous iterator.
func (this ForgeFedDependsOnPropertyIterator) Prev() vocab.ForgeFedDependsOnPropertyIterator {
	if this.myIdx-1 < 0 {
		return nil
	} else {
		return this.parent.At(this.myIdx - 1)
	}
}

// Set sets the value of this property. Calling IsForgeFedTicket afterwards will
// return true.
func (this *ForgeFedDependsOnPropertyIterator) Set(v vocab.ForgeFedTicket) {
	this.clear()
	this.forgefedTicketMember = v
}

// SetIRI sets the value of this property. Calling IsIRI afterwards will return
// true.
func (this *ForgeFedDependsOnPropertyIterator) SetIRI(v *url.URL) {
	this.clear()
	this.iri = v
}

// SetType attempts to set the property for the arbitrary type. Returns an error
// if it is not a valid type to set on this property.
func (this *ForgeFedDependsOnPropertyIterator) SetType(t vocab.Type) error {
	if v, ok := t.(vocab.ForgeFedTicket); ok {
		this.Set(v)
		return nil
	}

	return fmt.Errorf("illegal type to set on ForgeFedDependsOn property: %T", t)
}

// clear ensures no value of this property is set. Calling IsForgeFedTicket
// afterwards will return false.
func (this *ForgeFedDependsOnPropertyIterator) clear() {
	this.unknown = nil
	this.iri = nil
	this.forgefedTicketMember = nil
}

// serialize converts this into an interface representation suitable for
// marshalling into a text or binary format. Applications should not need this
// function as most typical use cases serialize types instead of individual
// properties. It is exposed for alternatives to go-fed implementations to use.
func (this ForgeFedDependsOnPropertyIterator) serialize() (interface{}, error) {
	if this.IsForgeFedTicket() {
		return this.Get().Serialize()
	} else if this.IsIRI() {
		return this.iri.String(), nil
	}
	return this.unknown, nil
}

// ForgeFedDependsOnProperty is the non-functional property "dependsOn". It is
// permitted to have one or more values, and of different value types.
type ForgeFedDependsOnProperty struct {
	properties []*ForgeFedDependsOnPropertyIterator
	alias      string
}

// DeserializeDependsOnProperty creates a "dependsOn" property from an interface
// representation that has been unmarshalled from a text or binary format.
func DeserializeDependsOnProperty(m map[string]interface{}, aliasMap map[string]string) (vocab.ForgeFedDependsOnProperty, error) {
	alias := ""
	if a, ok := aliasMap["https://forgefed.peers.community/ns"]; ok {
		alias = a
	}
	propName := "dependsOn"
	if len(alias) > 0 {
		propName = fmt.Sprintf("%s:%s", alias, "dependsOn")
	}
	i, ok := m[propName]

	if ok {
		this := &ForgeFedDependsOnProperty{
			alias:      alias,
			properties: []*ForgeFedDependsOnPropertyIterator{},
		}
		if list, ok := i.([]interface{}); ok {
			for _, iterator := range list {
				if p, err := deserializeForgeFedDependsOnPropertyIterator(iterator, aliasMap); err != nil {
					return this, err
				} else if p != nil {
					this.properties = append(this.properties, p)
				}
			}
		} else {
			if p, err := deserializeForgeFedDependsOnPropertyIterator(i, aliasMap); err != nil {
				return this, err
			} else if p != nil {
				this.properties = append(this.properties, p)
			}
		}
		// Set up the properties for iteration.
		for idx, ele := range this.properties {
			ele.parent = this
			ele.myIdx = idx
		}
		return this, nil
	}
	return nil, nil
}

// NewForgeFedDependsOnProperty creates a new dependsOn property.
func NewForgeFedDependsOnProperty() *ForgeFedDependsOnProperty {
	return &ForgeFedDependsOnProperty{alias: ""}
}

// AppendForgeFedTicket appends a Ticket value to the back of a list of the
// property "dependsOn". Invalidates iterators that are traversing using Prev.
func (this *ForgeFedDependsOnProperty) AppendForgeFedTicket(v vocab.ForgeFedTicket) {
	this.properties = append(this.properties, &ForgeFedDependsOnPropertyIterator{
		alias:                this.alias,
		forgefedTicketMember: v,
		myIdx:                this.Len(),
		parent:               this,
	})
}

// AppendIRI appends an IRI value to the back of a list of the property "dependsOn"
func (this *ForgeFedDependsOnProperty) AppendIRI(v *url.URL) {
	this.properties = append(this.properties, &ForgeFedDependsOnPropertyIterator{
		alias:  this.alias,
		iri:    v,
		myIdx:  this.Len(),
		parent: this,
	})
}

// PrependType prepends an arbitrary type value to the front of a list of the
// property "dependsOn". Invalidates iterators that are traversing using Prev.
// Returns an error if the type is not a valid one to set for this property.
func (this *ForgeFedDependsOnProperty) AppendType(t vocab.Type) error {
	n := &ForgeFedDependsOnPropertyIterator{
		alias:  this.alias,
		myIdx:  this.Len(),
		parent: this,
	}
	if err := n.SetType(t); err != nil {
		return err
	}
	this.properties = append(this.properties, n)
	return nil
}

// At returns the property value for the specified index. Panics if the index is
// out of bounds.
func (this ForgeFedDependsOnProperty) At(index int) vocab.ForgeFedDependsOnPropertyIterator {
	return this.properties[index]
}

// Begin returns the first iterator, or nil if empty. Can be used with the
// iterator's Next method and this property's End method to iterate from front
// to back through all values.
func (this ForgeFedDependsOnProperty) Begin() vocab.ForgeFedDependsOnPropertyIterator {
	if this.Empty() {
		return nil
	} else {
		return this.properties[0]
	}
}

// Empty returns returns true if there are no elements.
func (this ForgeFedDependsOnProperty) Empty() bool {
	return this.Len() == 0
}

// End returns beyond-the-last iterator, which is nil. Can be used with the
// iterator's Next method and this property's Begin method to iterate from
// front to back through all values.
func (this ForgeFedDependsOnProperty) End() vocab.ForgeFedDependsOnPropertyIterator {
	return nil
}

// InsertForgeFedTicket inserts a Ticket value at the specified index for a
// property "dependsOn". Existing elements at that index and higher are
// shifted back once. Invalidates all iterators.
func (this *ForgeFedDependsOnProperty) InsertForgeFedTicket(idx int, v vocab.ForgeFedTicket) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ForgeFedDependsOnPropertyIterator{
		alias:                this.alias,
		forgefedTicketMember: v,
		myIdx:                idx,
		parent:               this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// Insert inserts an IRI value at the specified index for a property "dependsOn".
// Existing elements at that index and higher are shifted back once.
// Invalidates all iterators.
func (this *ForgeFedDependsOnProperty) InsertIRI(idx int, v *url.URL) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ForgeFedDependsOnPropertyIterator{
		alias:  this.alias,
		iri:    v,
		myIdx:  idx,
		parent: this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependType prepends an arbitrary type value to the front of a list of the
// property "dependsOn". Invalidates all iterators. Returns an error if the
// type is not a valid one to set for this property.
func (this *ForgeFedDependsOnProperty) InsertType(idx int, t vocab.Type) error {
	n := &ForgeFedDependsOnPropertyIterator{
		alias:  this.alias,
		myIdx:  idx,
		parent: this,
	}
	if err := n.SetType(t); err != nil {
		return err
	}
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = n
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
	return nil
}

// JSONLDContext returns the JSONLD URIs required in the context string for this
// property and the specific values that are set. The value in the map is the
// alias used to import the property's value or values.
func (this ForgeFedDependsOnProperty) JSONLDContext() map[string]string {
	m := map[string]string{"https://forgefed.peers.community/ns": this.alias}
	for _, elem := range this.properties {
		child := elem.JSONLDContext()
		/*
		   Since the literal maps in this function are determined at
		   code-generation time, this loop should not overwrite an existing key with a
		   new value.
		*/
		for k, v := range child {
			m[k] = v
		}
	}
	return m
}

// KindIndex computes an arbitrary value for indexing this kind of value. This is
// a leaky API method specifically needed only for alternate implementations
// for go-fed. Applications should not use this method. Panics if the index is
// out of bounds.
func (this ForgeFedDependsOnProperty) KindIndex(idx int) int {
	return this.properties[idx].KindIndex()
}

// Len returns the number of values that exist for the "dependsOn" property.
func (this ForgeFedDependsOnProperty) Len() (length int) {
	return len(this.properties)
}

// Less computes whether another property is less than this one. Mixing types
// results in a consistent but arbitrary ordering
func (this ForgeFedDependsOnProperty) Less(i, j int) bool {
	idx1 := this.KindIndex(i)
	idx2 := this.KindIndex(j)
	if idx1 < idx2 {
		return true
	} else if idx1 == idx2 {
		if idx1 == 0 {
			lhs := this.properties[i].Get()
			rhs := this.properties[j].Get()
			return lhs.LessThan(rhs)
		} else if idx1 == -2 {
			lhs := this.properties[i].GetIRI()
			rhs := this.properties[j].GetIRI()
			return lhs.String() < rhs.String()
		}
	}
	return false
}

// LessThan compares two instances of this property with an arbitrary but stable
// comparison. Applications should not use this because it is only meant to
// help alternative implementations to go-fed to be able to normalize
// nonfunctional properties.
func (this ForgeFedDependsOnProperty) LessThan(o vocab.ForgeFedDependsOnProperty) bool {
	l1 := this.Len()
	l2 := o.Len()
	l := l1
	if l2 < l1 {
		l = l2
	}
	for i := 0; i < l; i++ {
		if this.properties[i].LessThan(o.At(i)) {
			return true
		} else if o.At(i).LessThan(this.properties[i]) {
			return false
		}
	}
	return l1 < l2
}

// Name returns the name of this property ("dependsOn") with any alias.
func (this ForgeFedDependsOnProperty) Name() string {
	if len(this.alias) > 0 {
		return this.alias + ":" + "dependsOn"
	} else {
		return "dependsOn"
	}
}

// PrependForgeFedTicket prepends a Ticket value to the front of a list of the
// property "dependsOn". Invalidates all iterators.
func (this *ForgeFedDependsOnProperty) PrependForgeFedTicket(v vocab.ForgeFedTicket) {
	this.properties = append([]*ForgeFedDependsOnPropertyIterator{{
		alias:                this.alias,
		forgefedTicketMember: v,
		myIdx:                0,
		parent:               this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependIRI prepends an IRI value to the front of a list of the property
// "dependsOn".
func (this *ForgeFedDependsOnProperty) PrependIRI(v *url.URL) {
	this.properties = append([]*ForgeFedDependsOnPropertyIterator{{
		alias:  this.alias,
		iri:    v,
		myIdx:  0,
		parent: this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependType prepends an arbitrary type value to the front of a list of the
// property "dependsOn". Invalidates all iterators. Returns an error if the
// type is not a valid one to set for this property.
func (this *ForgeFedDependsOnProperty) PrependType(t vocab.Type) error {
	n := &ForgeFedDependsOnPropertyIterator{
		alias:  this.alias,
		myIdx:  0,
		parent: this,
	}
	if err := n.SetType(t); err != nil {
		return err
	}
	this.properties = append([]*ForgeFedDependsOnPropertyIterator{n}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
	return nil
}

// Remove deletes an element at the specified index from a list of the property
// "dependsOn", regardless of its type. Panics if the index is out of bounds.
// Invalidates all iterators.
func (this *ForgeFedDependsOnProperty) Remove(idx int) {
	(this.properties)[idx].parent = nil
	copy((this.properties)[idx:], (this.properties)[idx+1:])
	(this.properties)[len(this.properties)-1] = &ForgeFedDependsOnPropertyIterator{}
	this.properties = (this.properties)[:len(this.properties)-1]
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// Serialize converts this into an interface representation suitable for
// marshalling into a text or binary format. Applications should not need this
// function as most typical use cases serialize types instead of individual
// properties. It is exposed for alternatives to go-fed implementations to use.
func (this ForgeFedDependsOnProperty) Serialize() (interface{}, error) {
	s := make([]interface{}, 0, len(this.properties))
	for _, iterator := range this.properties {
		if b, err := iterator.serialize(); err != nil {
			return s, err
		} else {
			s = append(s, b)
		}
	}
	// Shortcut: if serializing one value, don't return an array -- pretty sure other Fediverse software would choke on a "type" value with array, for example.
	if len(s) == 1 {
		return s[0], nil
	}
	return s, nil
}

// Set sets a Ticket value to be at the specified index for the property
// "dependsOn". Panics if the index is out of bounds. Invalidates all
// iterators.
func (this *ForgeFedDependsOnProperty) Set(idx int, v vocab.ForgeFedTicket) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ForgeFedDependsOnPropertyIterator{
		alias:                this.alias,
		forgefedTicketMember: v,
		myIdx:                idx,
		parent:               this,
	}
}

// SetIRI sets an IRI value to be at the specified index for the property
// "dependsOn". Panics if the index is out of bounds.
func (this *ForgeFedDependsOnProperty) SetIRI(idx int, v *url.URL) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ForgeFedDependsOnPropertyIterator{
		alias:  this.alias,
		iri:    v,
		myIdx:  idx,
		parent: this,
	}
}

// SetType sets an arbitrary type value to the specified index of the property
// "dependsOn". Invalidates all iterators. Returns an error if the type is not
// a valid one to set for this property. Panics if the index is out of bounds.
func (this *ForgeFedDependsOnProperty) SetType(idx int, t vocab.Type) error {
	n := &ForgeFedDependsOnPropertyIterator{
		alias:  this.alias,
		myIdx:  idx,
		parent: this,
	}
	if err := n.SetType(t); err != nil {
		return err
	}
	(this.properties)[idx] = n
	return nil
}

// Swap swaps the location of values at two indices for the "dependsOn" property.
func (this ForgeFedDependsOnProperty) Swap(i, j int) {
	this.properties[i], this.properties[j] = this.properties[j], this.properties[i]
}
