// Code generated by astool. DO NOT EDIT.

package propertydependedby

import (
	"fmt"
	vocab "github.com/go-fed/activity/streams/vocab"
	"net/url"
)

// ForgeFedDependedByPropertyIterator is an iterator for a property. It is
// permitted to be a single nilable value type.
type ForgeFedDependedByPropertyIterator struct {
	forgefedTicketMember vocab.ForgeFedTicket
	unknown              interface{}
	iri                  *url.URL
	alias                string
	myIdx                int
	parent               vocab.ForgeFedDependedByProperty
}

// NewForgeFedDependedByPropertyIterator creates a new ForgeFedDependedBy property.
func NewForgeFedDependedByPropertyIterator() *ForgeFedDependedByPropertyIterator {
	return &ForgeFedDependedByPropertyIterator{alias: ""}
}

// deserializeForgeFedDependedByPropertyIterator creates an iterator from an
// element that has been unmarshalled from a text or binary format.
func deserializeForgeFedDependedByPropertyIterator(i interface{}, aliasMap map[string]string) (*ForgeFedDependedByPropertyIterator, error) {
	alias := ""
	if a, ok := aliasMap["https://forgefed.peers.community/ns"]; ok {
		alias = a
	}
	if s, ok := i.(string); ok {
		u, err := url.Parse(s)
		// If error exists, don't error out -- skip this and treat as unknown string ([]byte) at worst
		// Also, if no scheme exists, don't treat it as a URL -- net/url is greedy
		if err == nil && len(u.Scheme) > 0 {
			this := &ForgeFedDependedByPropertyIterator{
				alias: alias,
				iri:   u,
			}
			return this, nil
		}
	}
	if m, ok := i.(map[string]interface{}); ok {
		if v, err := mgr.DeserializeTicketForgeFed()(m, aliasMap); err == nil {
			this := &ForgeFedDependedByPropertyIterator{
				alias:                alias,
				forgefedTicketMember: v,
			}
			return this, nil
		}
	}
	this := &ForgeFedDependedByPropertyIterator{
		alias:   alias,
		unknown: i,
	}
	return this, nil
}

// Get returns the value of this property. When IsForgeFedTicket returns false,
// Get will return any arbitrary value.
func (this ForgeFedDependedByPropertyIterator) Get() vocab.ForgeFedTicket {
	return this.forgefedTicketMember
}

// GetIRI returns the IRI of this property. When IsIRI returns false, GetIRI will
// return any arbitrary value.
func (this ForgeFedDependedByPropertyIterator) GetIRI() *url.URL {
	return this.iri
}

// GetType returns the value in this property as a Type. Returns nil if the value
// is not an ActivityStreams type, such as an IRI or another value.
func (this ForgeFedDependedByPropertyIterator) GetType() vocab.Type {
	if this.IsForgeFedTicket() {
		return this.Get()
	}

	return nil
}

// HasAny returns true if the value or IRI is set.
func (this ForgeFedDependedByPropertyIterator) HasAny() bool {
	return this.IsForgeFedTicket() || this.iri != nil
}

// IsForgeFedTicket returns true if this property is set and not an IRI.
func (this ForgeFedDependedByPropertyIterator) IsForgeFedTicket() bool {
	return this.forgefedTicketMember != nil
}

// IsIRI returns true if this property is an IRI.
func (this ForgeFedDependedByPropertyIterator) IsIRI() bool {
	return this.iri != nil
}

// JSONLDContext returns the JSONLD URIs required in the context string for this
// property and the specific values that are set. The value in the map is the
// alias used to import the property's value or values.
func (this ForgeFedDependedByPropertyIterator) JSONLDContext() map[string]string {
	m := map[string]string{"https://forgefed.peers.community/ns": this.alias}
	var child map[string]string
	if this.IsForgeFedTicket() {
		child = this.Get().JSONLDContext()
	}
	/*
	   Since the literal maps in this function are determined at
	   code-generation time, this loop should not overwrite an existing key with a
	   new value.
	*/
	for k, v := range child {
		m[k] = v
	}
	return m
}

// KindIndex computes an arbitrary value for indexing this kind of value. This is
// a leaky API detail only for folks looking to replace the go-fed
// implementation. Applications should not use this method.
func (this ForgeFedDependedByPropertyIterator) KindIndex() int {
	if this.IsForgeFedTicket() {
		return 0
	}
	if this.IsIRI() {
		return -2
	}
	return -1
}

// LessThan compares two instances of this property with an arbitrary but stable
// comparison. Applications should not use this because it is only meant to
// help alternative implementations to go-fed to be able to normalize
// nonfunctional properties.
func (this ForgeFedDependedByPropertyIterator) LessThan(o vocab.ForgeFedDependedByPropertyIterator) bool {
	// LessThan comparison for if either or both are IRIs.
	if this.IsIRI() && o.IsIRI() {
		return this.iri.String() < o.GetIRI().String()
	} else if this.IsIRI() {
		// IRIs are always less than other values, none, or unknowns
		return true
	} else if o.IsIRI() {
		// This other, none, or unknown value is always greater than IRIs
		return false
	}
	// LessThan comparison for the single value or unknown value.
	if !this.IsForgeFedTicket() && !o.IsForgeFedTicket() {
		// Both are unknowns.
		return false
	} else if this.IsForgeFedTicket() && !o.IsForgeFedTicket() {
		// Values are always greater than unknown values.
		return false
	} else if !this.IsForgeFedTicket() && o.IsForgeFedTicket() {
		// Unknowns are always less than known values.
		return true
	} else {
		// Actual comparison.
		return this.Get().LessThan(o.Get())
	}
}

// Name returns the name of this property: "ForgeFedDependedBy".
func (this ForgeFedDependedByPropertyIterator) Name() string {
	if len(this.alias) > 0 {
		return this.alias + ":" + "ForgeFedDependedBy"
	} else {
		return "ForgeFedDependedBy"
	}
}

// Next returns the next iterator, or nil if there is no next iterator.
func (this ForgeFedDependedByPropertyIterator) Next() vocab.ForgeFedDependedByPropertyIterator {
	if this.myIdx+1 >= this.parent.Len() {
		return nil
	} else {
		return this.parent.At(this.myIdx + 1)
	}
}

// Prev returns the previous iterator, or nil if there is no previous iterator.
func (this ForgeFedDependedByPropertyIterator) Prev() vocab.ForgeFedDependedByPropertyIterator {
	if this.myIdx-1 < 0 {
		return nil
	} else {
		return this.parent.At(this.myIdx - 1)
	}
}

// Set sets the value of this property. Calling IsForgeFedTicket afterwards will
// return true.
func (this *ForgeFedDependedByPropertyIterator) Set(v vocab.ForgeFedTicket) {
	this.clear()
	this.forgefedTicketMember = v
}

// SetIRI sets the value of this property. Calling IsIRI afterwards will return
// true.
func (this *ForgeFedDependedByPropertyIterator) SetIRI(v *url.URL) {
	this.clear()
	this.iri = v
}

// SetType attempts to set the property for the arbitrary type. Returns an error
// if it is not a valid type to set on this property.
func (this *ForgeFedDependedByPropertyIterator) SetType(t vocab.Type) error {
	if v, ok := t.(vocab.ForgeFedTicket); ok {
		this.Set(v)
		return nil
	}

	return fmt.Errorf("illegal type to set on ForgeFedDependedBy property: %T", t)
}

// clear ensures no value of this property is set. Calling IsForgeFedTicket
// afterwards will return false.
func (this *ForgeFedDependedByPropertyIterator) clear() {
	this.unknown = nil
	this.iri = nil
	this.forgefedTicketMember = nil
}

// serialize converts this into an interface representation suitable for
// marshalling into a text or binary format. Applications should not need this
// function as most typical use cases serialize types instead of individual
// properties. It is exposed for alternatives to go-fed implementations to use.
func (this ForgeFedDependedByPropertyIterator) serialize() (interface{}, error) {
	if this.IsForgeFedTicket() {
		return this.Get().Serialize()
	} else if this.IsIRI() {
		return this.iri.String(), nil
	}
	return this.unknown, nil
}

// ForgeFedDependedByProperty is the non-functional property "dependedBy". It is
// permitted to have one or more values, and of different value types.
type ForgeFedDependedByProperty struct {
	properties []*ForgeFedDependedByPropertyIterator
	alias      string
}

// DeserializeDependedByProperty creates a "dependedBy" property from an interface
// representation that has been unmarshalled from a text or binary format.
func DeserializeDependedByProperty(m map[string]interface{}, aliasMap map[string]string) (vocab.ForgeFedDependedByProperty, error) {
	alias := ""
	if a, ok := aliasMap["https://forgefed.peers.community/ns"]; ok {
		alias = a
	}
	propName := "dependedBy"
	if len(alias) > 0 {
		propName = fmt.Sprintf("%s:%s", alias, "dependedBy")
	}
	i, ok := m[propName]

	if ok {
		this := &ForgeFedDependedByProperty{
			alias:      alias,
			properties: []*ForgeFedDependedByPropertyIterator{},
		}
		if list, ok := i.([]interface{}); ok {
			for _, iterator := range list {
				if p, err := deserializeForgeFedDependedByPropertyIterator(iterator, aliasMap); err != nil {
					return this, err
				} else if p != nil {
					this.properties = append(this.properties, p)
				}
			}
		} else {
			if p, err := deserializeForgeFedDependedByPropertyIterator(i, aliasMap); err != nil {
				return this, err
			} else if p != nil {
				this.properties = append(this.properties, p)
			}
		}
		// Set up the properties for iteration.
		for idx, ele := range this.properties {
			ele.parent = this
			ele.myIdx = idx
		}
		return this, nil
	}
	return nil, nil
}

// NewForgeFedDependedByProperty creates a new dependedBy property.
func NewForgeFedDependedByProperty() *ForgeFedDependedByProperty {
	return &ForgeFedDependedByProperty{alias: ""}
}

// AppendForgeFedTicket appends a Ticket value to the back of a list of the
// property "dependedBy". Invalidates iterators that are traversing using Prev.
func (this *ForgeFedDependedByProperty) AppendForgeFedTicket(v vocab.ForgeFedTicket) {
	this.properties = append(this.properties, &ForgeFedDependedByPropertyIterator{
		alias:                this.alias,
		forgefedTicketMember: v,
		myIdx:                this.Len(),
		parent:               this,
	})
}

// AppendIRI appends an IRI value to the back of a list of the property
// "dependedBy"
func (this *ForgeFedDependedByProperty) AppendIRI(v *url.URL) {
	this.properties = append(this.properties, &ForgeFedDependedByPropertyIterator{
		alias:  this.alias,
		iri:    v,
		myIdx:  this.Len(),
		parent: this,
	})
}

// PrependType prepends an arbitrary type value to the front of a list of the
// property "dependedBy". Invalidates iterators that are traversing using
// Prev. Returns an error if the type is not a valid one to set for this
// property.
func (this *ForgeFedDependedByProperty) AppendType(t vocab.Type) error {
	n := &ForgeFedDependedByPropertyIterator{
		alias:  this.alias,
		myIdx:  this.Len(),
		parent: this,
	}
	if err := n.SetType(t); err != nil {
		return err
	}
	this.properties = append(this.properties, n)
	return nil
}

// At returns the property value for the specified index. Panics if the index is
// out of bounds.
func (this ForgeFedDependedByProperty) At(index int) vocab.ForgeFedDependedByPropertyIterator {
	return this.properties[index]
}

// Begin returns the first iterator, or nil if empty. Can be used with the
// iterator's Next method and this property's End method to iterate from front
// to back through all values.
func (this ForgeFedDependedByProperty) Begin() vocab.ForgeFedDependedByPropertyIterator {
	if this.Empty() {
		return nil
	} else {
		return this.properties[0]
	}
}

// Empty returns returns true if there are no elements.
func (this ForgeFedDependedByProperty) Empty() bool {
	return this.Len() == 0
}

// End returns beyond-the-last iterator, which is nil. Can be used with the
// iterator's Next method and this property's Begin method to iterate from
// front to back through all values.
func (this ForgeFedDependedByProperty) End() vocab.ForgeFedDependedByPropertyIterator {
	return nil
}

// InsertForgeFedTicket inserts a Ticket value at the specified index for a
// property "dependedBy". Existing elements at that index and higher are
// shifted back once. Invalidates all iterators.
func (this *ForgeFedDependedByProperty) InsertForgeFedTicket(idx int, v vocab.ForgeFedTicket) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ForgeFedDependedByPropertyIterator{
		alias:                this.alias,
		forgefedTicketMember: v,
		myIdx:                idx,
		parent:               this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// Insert inserts an IRI value at the specified index for a property "dependedBy".
// Existing elements at that index and higher are shifted back once.
// Invalidates all iterators.
func (this *ForgeFedDependedByProperty) InsertIRI(idx int, v *url.URL) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ForgeFedDependedByPropertyIterator{
		alias:  this.alias,
		iri:    v,
		myIdx:  idx,
		parent: this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependType prepends an arbitrary type value to the front of a list of the
// property "dependedBy". Invalidates all iterators. Returns an error if the
// type is not a valid one to set for this property.
func (this *ForgeFedDependedByProperty) InsertType(idx int, t vocab.Type) error {
	n := &ForgeFedDependedByPropertyIterator{
		alias:  this.alias,
		myIdx:  idx,
		parent: this,
	}
	if err := n.SetType(t); err != nil {
		return err
	}
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = n
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
	return nil
}

// JSONLDContext returns the JSONLD URIs required in the context string for this
// property and the specific values that are set. The value in the map is the
// alias used to import the property's value or values.
func (this ForgeFedDependedByProperty) JSONLDContext() map[string]string {
	m := map[string]string{"https://forgefed.peers.community/ns": this.alias}
	for _, elem := range this.properties {
		child := elem.JSONLDContext()
		/*
		   Since the literal maps in this function are determined at
		   code-generation time, this loop should not overwrite an existing key with a
		   new value.
		*/
		for k, v := range child {
			m[k] = v
		}
	}
	return m
}

// KindIndex computes an arbitrary value for indexing this kind of value. This is
// a leaky API method specifically needed only for alternate implementations
// for go-fed. Applications should not use this method. Panics if the index is
// out of bounds.
func (this ForgeFedDependedByProperty) KindIndex(idx int) int {
	return this.properties[idx].KindIndex()
}

// Len returns the number of values that exist for the "dependedBy" property.
func (this ForgeFedDependedByProperty) Len() (length int) {
	return len(this.properties)
}

// Less computes whether another property is less than this one. Mixing types
// results in a consistent but arbitrary ordering
func (this ForgeFedDependedByProperty) Less(i, j int) bool {
	idx1 := this.KindIndex(i)
	idx2 := this.KindIndex(j)
	if idx1 < idx2 {
		return true
	} else if idx1 == idx2 {
		if idx1 == 0 {
			lhs := this.properties[i].Get()
			rhs := this.properties[j].Get()
			return lhs.LessThan(rhs)
		} else if idx1 == -2 {
			lhs := this.properties[i].GetIRI()
			rhs := this.properties[j].GetIRI()
			return lhs.String() < rhs.String()
		}
	}
	return false
}

// LessThan compares two instances of this property with an arbitrary but stable
// comparison. Applications should not use this because it is only meant to
// help alternative implementations to go-fed to be able to normalize
// nonfunctional properties.
func (this ForgeFedDependedByProperty) LessThan(o vocab.ForgeFedDependedByProperty) bool {
	l1 := this.Len()
	l2 := o.Len()
	l := l1
	if l2 < l1 {
		l = l2
	}
	for i := 0; i < l; i++ {
		if this.properties[i].LessThan(o.At(i)) {
			return true
		} else if o.At(i).LessThan(this.properties[i]) {
			return false
		}
	}
	return l1 < l2
}

// Name returns the name of this property ("dependedBy") with any alias.
func (this ForgeFedDependedByProperty) Name() string {
	if len(this.alias) > 0 {
		return this.alias + ":" + "dependedBy"
	} else {
		return "dependedBy"
	}
}

// PrependForgeFedTicket prepends a Ticket value to the front of a list of the
// property "dependedBy". Invalidates all iterators.
func (this *ForgeFedDependedByProperty) PrependForgeFedTicket(v vocab.ForgeFedTicket) {
	this.properties = append([]*ForgeFedDependedByPropertyIterator{{
		alias:                this.alias,
		forgefedTicketMember: v,
		myIdx:                0,
		parent:               this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependIRI prepends an IRI value to the front of a list of the property
// "dependedBy".
func (this *ForgeFedDependedByProperty) PrependIRI(v *url.URL) {
	this.properties = append([]*ForgeFedDependedByPropertyIterator{{
		alias:  this.alias,
		iri:    v,
		myIdx:  0,
		parent: this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependType prepends an arbitrary type value to the front of a list of the
// property "dependedBy". Invalidates all iterators. Returns an error if the
// type is not a valid one to set for this property.
func (this *ForgeFedDependedByProperty) PrependType(t vocab.Type) error {
	n := &ForgeFedDependedByPropertyIterator{
		alias:  this.alias,
		myIdx:  0,
		parent: this,
	}
	if err := n.SetType(t); err != nil {
		return err
	}
	this.properties = append([]*ForgeFedDependedByPropertyIterator{n}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
	return nil
}

// Remove deletes an element at the specified index from a list of the property
// "dependedBy", regardless of its type. Panics if the index is out of bounds.
// Invalidates all iterators.
func (this *ForgeFedDependedByProperty) Remove(idx int) {
	(this.properties)[idx].parent = nil
	copy((this.properties)[idx:], (this.properties)[idx+1:])
	(this.properties)[len(this.properties)-1] = &ForgeFedDependedByPropertyIterator{}
	this.properties = (this.properties)[:len(this.properties)-1]
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// Serialize converts this into an interface representation suitable for
// marshalling into a text or binary format. Applications should not need this
// function as most typical use cases serialize types instead of individual
// properties. It is exposed for alternatives to go-fed implementations to use.
func (this ForgeFedDependedByProperty) Serialize() (interface{}, error) {
	s := make([]interface{}, 0, len(this.properties))
	for _, iterator := range this.properties {
		if b, err := iterator.serialize(); err != nil {
			return s, err
		} else {
			s = append(s, b)
		}
	}
	// Shortcut: if serializing one value, don't return an array -- pretty sure other Fediverse software would choke on a "type" value with array, for example.
	if len(s) == 1 {
		return s[0], nil
	}
	return s, nil
}

// Set sets a Ticket value to be at the specified index for the property
// "dependedBy". Panics if the index is out of bounds. Invalidates all
// iterators.
func (this *ForgeFedDependedByProperty) Set(idx int, v vocab.ForgeFedTicket) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ForgeFedDependedByPropertyIterator{
		alias:                this.alias,
		forgefedTicketMember: v,
		myIdx:                idx,
		parent:               this,
	}
}

// SetIRI sets an IRI value to be at the specified index for the property
// "dependedBy". Panics if the index is out of bounds.
func (this *ForgeFedDependedByProperty) SetIRI(idx int, v *url.URL) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ForgeFedDependedByPropertyIterator{
		alias:  this.alias,
		iri:    v,
		myIdx:  idx,
		parent: this,
	}
}

// SetType sets an arbitrary type value to the specified index of the property
// "dependedBy". Invalidates all iterators. Returns an error if the type is
// not a valid one to set for this property. Panics if the index is out of
// bounds.
func (this *ForgeFedDependedByProperty) SetType(idx int, t vocab.Type) error {
	n := &ForgeFedDependedByPropertyIterator{
		alias:  this.alias,
		myIdx:  idx,
		parent: this,
	}
	if err := n.SetType(t); err != nil {
		return err
	}
	(this.properties)[idx] = n
	return nil
}

// Swap swaps the location of values at two indices for the "dependedBy" property.
func (this ForgeFedDependedByProperty) Swap(i, j int) {
	this.properties[i], this.properties[j] = this.properties[j], this.properties[i]
}
