// Code generated by astool. DO NOT EDIT.

package propertyassignedto

import (
	"fmt"
	vocab "github.com/go-fed/activity/streams/vocab"
	"net/url"
)

// ForgeFedAssignedToProperty is the functional property "assignedTo". It is
// permitted to be a single nilable value type.
type ForgeFedAssignedToProperty struct {
	activitystreamsPersonMember vocab.ActivityStreamsPerson
	unknown                     interface{}
	iri                         *url.URL
	alias                       string
}

// DeserializeAssignedToProperty creates a "assignedTo" property from an interface
// representation that has been unmarshalled from a text or binary format.
func DeserializeAssignedToProperty(m map[string]interface{}, aliasMap map[string]string) (*ForgeFedAssignedToProperty, error) {
	alias := ""
	if a, ok := aliasMap["https://forgefed.peers.community/ns"]; ok {
		alias = a
	}
	propName := "assignedTo"
	if len(alias) > 0 {
		// Use alias both to find the property, and set within the property.
		propName = fmt.Sprintf("%s:%s", alias, "assignedTo")
	}
	i, ok := m[propName]

	if ok {
		if s, ok := i.(string); ok {
			u, err := url.Parse(s)
			// If error exists, don't error out -- skip this and treat as unknown string ([]byte) at worst
			// Also, if no scheme exists, don't treat it as a URL -- net/url is greedy
			if err == nil && len(u.Scheme) > 0 {
				this := &ForgeFedAssignedToProperty{
					alias: alias,
					iri:   u,
				}
				return this, nil
			}
		}
		if m, ok := i.(map[string]interface{}); ok {
			if v, err := mgr.DeserializePersonActivityStreams()(m, aliasMap); err == nil {
				this := &ForgeFedAssignedToProperty{
					activitystreamsPersonMember: v,
					alias:                       alias,
				}
				return this, nil
			}
		}
		this := &ForgeFedAssignedToProperty{
			alias:   alias,
			unknown: i,
		}
		return this, nil
	}
	return nil, nil
}

// NewForgeFedAssignedToProperty creates a new assignedTo property.
func NewForgeFedAssignedToProperty() *ForgeFedAssignedToProperty {
	return &ForgeFedAssignedToProperty{alias: ""}
}

// Clear ensures no value of this property is set. Calling IsActivityStreamsPerson
// afterwards will return false.
func (this *ForgeFedAssignedToProperty) Clear() {
	this.unknown = nil
	this.iri = nil
	this.activitystreamsPersonMember = nil
}

// Get returns the value of this property. When IsActivityStreamsPerson returns
// false, Get will return any arbitrary value.
func (this ForgeFedAssignedToProperty) Get() vocab.ActivityStreamsPerson {
	return this.activitystreamsPersonMember
}

// GetIRI returns the IRI of this property. When IsIRI returns false, GetIRI will
// return any arbitrary value.
func (this ForgeFedAssignedToProperty) GetIRI() *url.URL {
	return this.iri
}

// GetType returns the value in this property as a Type. Returns nil if the value
// is not an ActivityStreams type, such as an IRI or another value.
func (this ForgeFedAssignedToProperty) GetType() vocab.Type {
	if this.IsActivityStreamsPerson() {
		return this.Get()
	}

	return nil
}

// HasAny returns true if the value or IRI is set.
func (this ForgeFedAssignedToProperty) HasAny() bool {
	return this.IsActivityStreamsPerson() || this.iri != nil
}

// IsActivityStreamsPerson returns true if this property is set and not an IRI.
func (this ForgeFedAssignedToProperty) IsActivityStreamsPerson() bool {
	return this.activitystreamsPersonMember != nil
}

// IsIRI returns true if this property is an IRI.
func (this ForgeFedAssignedToProperty) IsIRI() bool {
	return this.iri != nil
}

// JSONLDContext returns the JSONLD URIs required in the context string for this
// property and the specific values that are set. The value in the map is the
// alias used to import the property's value or values.
func (this ForgeFedAssignedToProperty) JSONLDContext() map[string]string {
	m := map[string]string{"https://forgefed.peers.community/ns": this.alias}
	var child map[string]string
	if this.IsActivityStreamsPerson() {
		child = this.Get().JSONLDContext()
	}
	/*
	   Since the literal maps in this function are determined at
	   code-generation time, this loop should not overwrite an existing key with a
	   new value.
	*/
	for k, v := range child {
		m[k] = v
	}
	return m
}

// KindIndex computes an arbitrary value for indexing this kind of value. This is
// a leaky API detail only for folks looking to replace the go-fed
// implementation. Applications should not use this method.
func (this ForgeFedAssignedToProperty) KindIndex() int {
	if this.IsActivityStreamsPerson() {
		return 0
	}
	if this.IsIRI() {
		return -2
	}
	return -1
}

// LessThan compares two instances of this property with an arbitrary but stable
// comparison. Applications should not use this because it is only meant to
// help alternative implementations to go-fed to be able to normalize
// nonfunctional properties.
func (this ForgeFedAssignedToProperty) LessThan(o vocab.ForgeFedAssignedToProperty) bool {
	// LessThan comparison for if either or both are IRIs.
	if this.IsIRI() && o.IsIRI() {
		return this.iri.String() < o.GetIRI().String()
	} else if this.IsIRI() {
		// IRIs are always less than other values, none, or unknowns
		return true
	} else if o.IsIRI() {
		// This other, none, or unknown value is always greater than IRIs
		return false
	}
	// LessThan comparison for the single value or unknown value.
	if !this.IsActivityStreamsPerson() && !o.IsActivityStreamsPerson() {
		// Both are unknowns.
		return false
	} else if this.IsActivityStreamsPerson() && !o.IsActivityStreamsPerson() {
		// Values are always greater than unknown values.
		return false
	} else if !this.IsActivityStreamsPerson() && o.IsActivityStreamsPerson() {
		// Unknowns are always less than known values.
		return true
	} else {
		// Actual comparison.
		return this.Get().LessThan(o.Get())
	}
}

// Name returns the name of this property: "assignedTo".
func (this ForgeFedAssignedToProperty) Name() string {
	if len(this.alias) > 0 {
		return this.alias + ":" + "assignedTo"
	} else {
		return "assignedTo"
	}
}

// Serialize converts this into an interface representation suitable for
// marshalling into a text or binary format. Applications should not need this
// function as most typical use cases serialize types instead of individual
// properties. It is exposed for alternatives to go-fed implementations to use.
func (this ForgeFedAssignedToProperty) Serialize() (interface{}, error) {
	if this.IsActivityStreamsPerson() {
		return this.Get().Serialize()
	} else if this.IsIRI() {
		return this.iri.String(), nil
	}
	return this.unknown, nil
}

// Set sets the value of this property. Calling IsActivityStreamsPerson afterwards
// will return true.
func (this *ForgeFedAssignedToProperty) Set(v vocab.ActivityStreamsPerson) {
	this.Clear()
	this.activitystreamsPersonMember = v
}

// SetIRI sets the value of this property. Calling IsIRI afterwards will return
// true.
func (this *ForgeFedAssignedToProperty) SetIRI(v *url.URL) {
	this.Clear()
	this.iri = v
}

// SetType attempts to set the property for the arbitrary type. Returns an error
// if it is not a valid type to set on this property.
func (this *ForgeFedAssignedToProperty) SetType(t vocab.Type) error {
	if v, ok := t.(vocab.ActivityStreamsPerson); ok {
		this.Set(v)
		return nil
	}

	return fmt.Errorf("illegal type to set on assignedTo property: %T", t)
}
