<!--*- mode:markdown;mode:orgtbl -*-->

<!---
 Part of M3U8 parser & generator library.
 This doc explaines M3U8 tag occurence in different versions
 of HLS protocol and their status in Go library.

 Copyright 2013-2016 The Project Developers.
 See the AUTHORS and LICENSE files at the top-level directory of this distribution
 and at https://github.com/grafov/m3u8/

 ॐ तारे तुत्तारे तुरे स्व
-->

M3U8 tags cheatsheet
====================

The table above describes tags of M3U8, their occurence in playlists of different types and their support status
in the go-library.

Legend for playlist types:

* MAS is master playlist
* MED is media playlist

<!--- Note: markdown table below prepared in Emacs Orgmode and automatically converted to Github Markdown format -->

<!--- BEGIN RECEIVE ORGTBL specs -->
| Tag | Occured in | Proto ver | In Go lib since |
|---|---|---|---|
| EXT-X-ALLOW-CACHE | MED | 1 | 0.1 |
| EXT-X-BYTERANGE | MED | 4 | 0.1 |
| EXT-X-DISCONTINUITY | MED | 1 | 0.2 |
| EXT-X-DISCONTINUITY-SEQUENCE | MED | 6 |  |
| EXT-X-ENDLIST | MED | 1 | 0.1 |
| EXT-X-I-FRAME-STREAM-INF | MAS | 4 | 0.3 |
| EXT-X-I-FRAMES-ONLY | MED | 4 | 0.3 |
| EXT-X-INDEPENDENT-SEGMENTS | MAS | 6 |  |
| EXT-X-KEY | MED | 1 | 0.1 |
| EXT-X-MAP | MED | 5 | 0.3 |
| EXT-X-MEDIA | MAS | 4 | 0.1 |
| EXT-X-MEDIA-SEQUENCE | MED | 1 | 0.1 |
| EXT-X-PLAYLIST-TYPE | MED | 3 | 0.2 |
| EXT-X-PROGRAM-DATE-TIME | MED | 1 | 0.2 |
| EXT-X-SESSION-DATA | MAS | 7 |  |
| EXT-X-START | MAS | 6 |  |
| EXT-X-STREAM-INF | MAS | 1 | 0.1 |
| EXT-X-TARGETDURATION | MED | 1 | 0.1 |
| EXT-X-VERSION | MAS | 2 | 0.1 |
| EXTINF | MED | 1 | 0.1 |
| EXTM3U | MAS,MED | 1 | 0.1 |
<!--- END RECEIVE ORGTBL specs -->

<!---
#+ORGTBL: SEND specs orgtbl-to-gfm
| Tag                          | Occured in | Proto ver | In Go lib since |
|------------------------------+------------+-----------+-----------------|
|                              |            | <l>       | <l>             |
| EXT-X-ALLOW-CACHE            | MED        | 1         | 0.1             |
| EXT-X-BYTERANGE              | MED        | 4         | 0.1             |
| EXT-X-DISCONTINUITY          | MED        | 1         | 0.2             |
| EXT-X-DISCONTINUITY-SEQUENCE | MED        | 6         |                 |
| EXT-X-ENDLIST                | MED        | 1         | 0.1             |
| EXT-X-I-FRAME-STREAM-INF     | MAS        | 4         | 0.3             |
| EXT-X-I-FRAMES-ONLY          | MED        | 4         | 0.3             |
| EXT-X-INDEPENDENT-SEGMENTS   | MAS        | 6         |                 |
| EXT-X-KEY                    | MED        | 1         | 0.1             |
| EXT-X-MAP                    | MED        | 5         | 0.3             |
| EXT-X-MEDIA                  | MAS        | 4         | 0.1             |
| EXT-X-MEDIA-SEQUENCE         | MED        | 1         | 0.1             |
| EXT-X-PLAYLIST-TYPE          | MED        | 3         | 0.2             |
| EXT-X-PROGRAM-DATE-TIME      | MED        | 1         | 0.2             |
| EXT-X-SESSION-DATA           | MAS        | 7         |                 |
| EXT-X-START                  | MAS        | 6         |                 |
| EXT-X-STREAM-INF             | MAS        | 1         | 0.1             |
| EXT-X-TARGETDURATION         | MED        | 1         | 0.1             |
| EXT-X-VERSION                | MAS        | 2         | 0.1             |
| EXTINF                       | MED        | 1         | 0.1             |
| EXTM3U                       | MAS,MED    | 1         | 0.1             |
-->


IETF drafts notes
-----------------

[IETF](http://ietf.org) document currently in Draft status. Different versions of the document introduce changes of HLS protocol playlist formats. Latest version of the HLS protocol is version 7.

http://tools.ietf.org/html/draft-pantos-http-live-streaming

* Version 1 of the HLS protocol described in draft00-draft02.
* Version 2 of the HLS protocol described in draft03-draft04.
* Version 3 of the HLS protocol described in draft05-draft06.
* Version 4 of the HLS protocol described in draft07-draft08.
* Version 5 of the HLS protocol described in draft09-draft11.
* Version 6 of the HLS protocol described in draft12-draft13.
* Version 7 of the HLS protocol described in draft14-draft19.
