package cmd

import (
	"github.com/spf13/cobra"

	"github.com/evilmartians/lefthook/internal/command"
)

type validate struct{}

func (validate) New(opts *command.Options) *cobra.Command {
	var schema string
	cmd := cobra.Command{
		Use:     "validate",
		Short:   "Validate lefthook config",
		Example: "lefthook validate",
		Args:    cobra.NoArgs,
		RunE: func(_cmd *cobra.Command, _args []string) error {
			return command.Validate(opts, schema)
		},
	}

	cmd.Flags().StringVarP(&schema, "schema", "s", "", "path to JSON schema file")

	return &cmd
}
