package main

import (
	"net/http"

	"github.com/CAFxX/httpcompression"
	"github.com/CAFxX/httpcompression/contrib/klauspost/zstd"

	kpzstd "github.com/klauspost/compress/zstd"
)

var data = []byte(`==================================
========== Hello world! ==========
==================================
`)

var dictionary = []byte{
	0x37, 0xa4, 0x30, 0xec, 0xd1, 0xa6, 0x6c, 0x2e, 0x1a, 0x10, 0xe8, 0x0d,
	0x07, 0xff, 0xff, 0xff, 0xb7, 0xbb, 0xf3, 0x9b, 0xec, 0xce, 0x6f, 0xb2,
	0x9b, 0xd2, 0x7f, 0xca, 0x2f, 0x29, 0xf2, 0x29, 0xa3, 0x0e, 0x11, 0x33,
	0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x0f, 0x00, 0x00, 0x00, 0x04,
	0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x35, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x54, 0x6e, 0x1f,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x08,
	0x00, 0x00, 0x00, 0x3d, 0x3d, 0x3d, 0x0a, 0x0a, 0x37, 0x50, 0x41, 0x59,
	0x56, 0x4c, 0x43, 0x59, 0x55, 0x34, 0x36, 0x48, 0x53, 0x4a, 0x5a, 0x57,
	0x4d, 0x51, 0x54, 0x58, 0x34, 0x53, 0x49, 0x36, 0x48, 0x4c, 0x4c, 0x55,
	0x43, 0x49, 0x4c, 0x49, 0x47, 0x43, 0x57, 0x43, 0x34, 0x54, 0x4f, 0x47,
	0x32, 0x45, 0x57, 0x51, 0x34, 0x50, 0x48, 0x53, 0x33, 0x47, 0x34, 0x59,
	0x47, 0x56, 0x41, 0x33, 0x46, 0x47, 0x58, 0x33, 0x57, 0x43, 0x37, 0x49,
	0x4d, 0x32, 0x34, 0x35, 0x35, 0x35, 0x52, 0x34, 0x59, 0x36, 0x56, 0x5a,
	0x0a, 0x57, 0x51, 0x56, 0x57, 0x43, 0x35, 0x56, 0x41, 0x44, 0x37, 0x49,
	0x4c, 0x46, 0x48, 0x4b, 0x34, 0x33, 0x41, 0x45, 0x50, 0x5a, 0x46, 0x46,
	0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d,
	0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d,
	0x0a, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x20,
	0x48, 0x65, 0x6c, 0x6c, 0x6f, 0x20, 0x77, 0x6f, 0x72, 0x6c, 0x64, 0x21,
	0x20, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x0a,
	0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d,
	0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d,
	0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x0a, 0x0a,
	0x52, 0x53, 0x4b, 0x33, 0x36, 0x4b, 0x4a, 0x46, 0x51, 0x4c, 0x51, 0x33,
	0x33, 0x4b, 0x36, 0x51, 0x49, 0x37, 0x4e, 0x52, 0x36, 0x44, 0x33, 0x37,
	0x48, 0x4c, 0x32, 0x47, 0x50, 0x32, 0x35, 0x57, 0x57, 0x4c, 0x45, 0x4e,
	0x43, 0x58, 0x4d, 0x4c, 0x4c, 0x33, 0x35, 0x53, 0x41, 0x59, 0x59, 0x37,
	0x4b, 0x56, 0x57, 0x47, 0x46, 0x53, 0x58, 0x49, 0x50, 0x32, 0x4f, 0x43,
	0x44, 0x33, 0x44, 0x52, 0x45, 0x35, 0x43, 0x4c, 0x54, 0x36, 0x4c, 0x47,
	0x49, 0x59, 0x4e, 0x54, 0x0a, 0x4c, 0x36, 0x55, 0x42, 0x4f, 0x35, 0x4d,
	0x45, 0x52, 0x56, 0x45, 0x34, 0x53, 0x41, 0x58, 0x57, 0x32, 0x37, 0x55,
	0x42, 0x42, 0x4a, 0x35, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d,
	0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d,
	0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d,
	0x3d, 0x3d, 0x0a, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d,
	0x3d, 0x20, 0x48, 0x65, 0x6c, 0x6c, 0x6f, 0x20, 0x77, 0x6f, 0x72, 0x6c,
	0x64, 0x21, 0x20, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d,
	0x3d, 0x0a, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d,
	0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d,
}

// To test the custom zstd dictionary, start this server and then run:
// $ curl -H "accept-encoding: zstd, z_2e6ca6d1" -v --output - localhost:8080 | zstd -d -D dictionary -c --no-progress -
// To test curl interoperability:
// $ curl --compressed -v --output - localhost:8080

func main() {
	zenc, _ := zstd.New()
	zdenc, _ := zstd.New(kpzstd.WithEncoderDict(dictionary))
	gz, _ := httpcompression.DefaultAdapter(
		httpcompression.MinSize(0),
		httpcompression.Compressor(zstd.Encoding, 2, zenc),
		httpcompression.Compressor("z_2e6ca6d1", 3, zdenc),
	)
	h := http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		w.Write(data)
	})
	http.Handle("/", gz(h))

	http.ListenAndServe(":8080", nil)
}
